/*
 * Decompiled with CFR 0.152.
 */
package emt.item.armor.boots;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emt.EMT;
import emt.util.EMTConfigHandler;
import emt.util.EMTTextHelper;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import thaumcraft.api.IRunicArmor;
import thaumcraft.api.IVisDiscountGear;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.Thaumcraft;

public class ItemElectricBootsTraveller
extends ItemArmor
implements IRunicArmor,
IElectricItem,
IVisDiscountGear,
IMetalArmor,
ISpecialArmor {
    public int maxCharge = 100000;
    public int energyPerDamage = 1000;
    public int visDiscount = 2;
    public float speedBonus = 0.055f;
    public float jumpBonus = 0.3f;
    public double transferLimit = 100.0;

    public ItemElectricBootsTraveller(ItemArmor.ArmorMaterial material, int par3, int par4) {
        super(material, par3, par4);
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.func_77637_a(EMT.TAB);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack itemStack = new ItemStack((Item)this, 1);
        if (this.getChargedItem(itemStack) == this) {
            ItemStack charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
        if (this.getEmptyItem(itemStack) == this) {
            itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("emt:armor/boots_electric");
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        double damageLimit = energyPerDamage <= 0 ? 0.0 : 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage;
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, (int)damageLimit);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (ElectricItem.manager.getCharge(armor) >= (double)this.getEnergyPerDamage()) {
            return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, (double)(damage * this.getEnergyPerDamage()), Integer.MAX_VALUE, true, false, false);
    }

    public double getDamageAbsorptionRatio() {
        return 0.5;
    }

    private double getBaseAbsorptionRatio() {
        return 0.15;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        list.add(EMTTextHelper.localize("tooltip.EMT.visDiscount") + ": " + String.valueOf(this.visDiscount) + "%");
    }

    public int getVisDiscount(ItemStack stack, EntityPlayer player, Aspect aspect) {
        return this.visDiscount;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!player.field_71075_bZ.field_75100_b && player.field_70701_bs > 0.0f) {
            if (player.field_70170_p.field_72995_K && !player.func_70093_af()) {
                if (!Thaumcraft.instance.entityEventHandler.prevStep.containsKey(player.func_145782_y())) {
                    Thaumcraft.instance.entityEventHandler.prevStep.put(player.func_145782_y(), Float.valueOf(player.field_70138_W));
                }
                player.field_70138_W = 1.0f;
            }
            if ((player.field_70122_E || player.field_71075_bZ.field_75100_b) && player.field_70701_bs > 0.0f) {
                player.func_70060_a(0.0f, 1.0f, this.speedBonus);
                player.field_70747_aH = this.jumpBonus;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            boolean hasArmor;
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            boolean bl = hasArmor = player.func_82169_q(0) != null && player.func_82169_q(0).func_77973_b() == this;
            if (hasArmor) {
                player.field_70181_x += (double)this.jumpBonus;
            }
        }
    }

    public float getMaxHealthyDropDist() {
        return 20.0f;
    }

    public float getMinimumDropDist() {
        return 4.0f;
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        if (EMT.instance.isSimulating() && event.entity instanceof EntityLivingBase && event.entity instanceof EntityPlayer) {
            EntityPlayer entity = (EntityPlayer)event.entity;
            if (entity.field_71071_by.field_70460_b[0] != null && entity.field_71071_by.field_70460_b[0].func_77973_b() instanceof ItemElectricBootsTraveller) {
                ItemElectricBootsTraveller tUsedBoots = (ItemElectricBootsTraveller)entity.field_71071_by.field_70460_b[0].func_77973_b();
                ItemStack stack = entity.field_71071_by.field_70460_b[0];
                if (tUsedBoots.getMinimumDropDist() > event.distance) {
                    event.setCanceled(true);
                } else {
                    float tEnergyDemand = (float)tUsedBoots.energyPerDamage * ((event.distance > tUsedBoots.getMaxHealthyDropDist() ? event.distance * 3.0f : event.distance) - 4.0f);
                    if ((double)tEnergyDemand <= ElectricItem.manager.getCharge(stack)) {
                        ElectricItem.manager.discharge(stack, (double)tEnergyDemand, Integer.MAX_VALUE, true, false, false);
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "emt:textures/models/electricboots.png";
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        if (!EMTConfigHandler.enchanting) {
            return 0;
        }
        return 4;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return EMTConfigHandler.enchanting;
    }

    public int getEnergyPerDamage() {
        return this.energyPerDamage;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return 2;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public int getRunicCharge(ItemStack itemStack) {
        return 0;
    }
}

